package ru.yandex.wmconsole.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Wraps a given string in a tag with given name.
 *
 * @author ailyin
 */
public class StringWrapper extends XmlDataWrapper<String> {
    public StringWrapper(String string, String tag) {
        super(string, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        result.append(StringEscapeUtils.escapeXml10(data));
    }
}
