package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.TcyInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class TcyInfoWrapper extends XmlDataWrapper<TcyInfo> {
    private static final String TAG_LIMIT = "tcy-limit";
    private static final String TAG_TCY = "tcy";

    public TcyInfoWrapper(TcyInfo info) {
        this(info, "tcy-too-small");
    }

    public TcyInfoWrapper(TcyInfo info, String tag) {
        super(info, tag);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_LIMIT, data.getLimit());
        putIntegerTag(result, TAG_TCY, data.getTcy());
    }
}
