package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmtools.common.data.info.TopQueryHistoryInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class TopQueryHistoryInfoWrapper<T> extends XmlDataWrapper<TopQueryHistoryInfo<T>> {
    public static final String TAG_QUERY = "query";
    public static final String ATTRIBUTE_REQUEST_ID = "id";
    public static final String TAG_NAME = "name";
    public static final String TAG_IN_TOPS_COUNT = "in-tops-count";
    public static final String TAG_SHOWS = "shows";
    public static final String TAG_CLICKS = "clicks";
    public static final String TAG_CTR = "ctr";
    public static final String TAG_POSITION = "position";
    public static final String TAG_PART = "part";
    public static final String TAG_DATA_NAME = "data-name";
    public static final String TAG_DATA_VALUE = "data-value";

    public TopQueryHistoryInfoWrapper(TopQueryHistoryInfo<T> info){
        super(info, TAG_QUERY, ATTRIBUTE_REQUEST_ID, Long.toString(info.getQueryId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_NAME, data.getQuery());
        putTag(result, TAG_SHOWS, Long.toString(data.getAvgShows()));
        putTag(result, TAG_CLICKS, Long.toString(data.getAvgClicks()));
        putTag(result, TAG_POSITION, Integer.toString(data.getAvgPosition()));
        putTag(result, TAG_CTR, Double.toString(data.getAvgCTR()));
        putTag(result, TAG_PART, Double.toString(data.getPart()));
        putTag(result, TAG_IN_TOPS_COUNT, Integer.toString(data.getInTopCount()));

        putTag(result, TAG_DATA_NAME, data.getDataName());
        putTag(result, TAG_DATA_VALUE, data.getData().toString());
    }
}
