package ru.yandex.wmconsole.data.wrappers;

import java.util.Collections;

import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.Node;
import ru.yandex.wmconsole.data.TreeNodeChildrenComparator;
import ru.yandex.wmconsole.data.info.TreeInfo;
import ru.yandex.wmconsole.data.info.TreeNodeInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author senin
 * @author ailyin
 */
public class TreeInfoWrapper extends XmlDataWrapper<TreeInfo> {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CURRENT = "current";
    private static final String TAG_NODE_NAME = "name";
    private static final String TAG_PARENT_URL_NODE_ID = "parent";
    private static final String TAG_HAS_CHILDREN = "has-children";
    private static final String TAG_NODE_URLS = "urls";
    private static final String TAG_HAS_INT_LINKS = "has-internal-links";
    private static final String TAG_HAS_EXT_LINKS = "has-external-links";
    private static final Object TAG_NODE = "node";
    private static final String TAG_INDEX_COUNT = "index-count";
    private static final String TAG_URLS_TREND = "urls-trend";
    private static final String TAG_INDEX_COUNT_TREND = "index-count-trend";

    private final OrderByClause order;
    private final boolean outputWholeTree;

    public TreeInfoWrapper(TreeInfo treeInfo, OrderByClause order, boolean outputWholeTree) {
        super(treeInfo);
        this.order = order;
        this.outputWholeTree = outputWholeTree;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data != null) {
            outputTree(result, data, data.getRootNode(), data.getSelectedNode());
        }
    }

    private void outputTree(StringBuilder result, TreeInfo treeInfo, Node node, Node selectedNode) {
        TreeNodeInfo info = node.getInfo();

        if (info.getUrlsInSubtree() == 0) {
            return;
        }

        outputOpenTag(result, info, selectedNode);
        outputNode(info, result, selectedNode);

        Node curNode = selectedNode;
        if (outputWholeTree) {
            outputChildren(node, result, treeInfo, selectedNode);
        } else {
            while (curNode != null) {
                if (curNode.getInfo().getId() == node.getInfo().getId()) {
                    outputChildren(node, result, treeInfo, selectedNode);
                    break;
                }
                curNode = treeInfo.getId2node().get(curNode.getInfo().getParentId());
            }
        }

        outputCloseTag(result);
    }

    private void outputChildren(Node node, StringBuilder result, TreeInfo treeInfo, Node selectedNode) {
        Collections.sort(node.getChildren(), TreeNodeChildrenComparator.getComparator(order));
        for (Node child : node.getChildren()) {
            outputTree(result, treeInfo, child, selectedNode);
        }
    }

    protected final void outputCloseTag(StringBuilder result) {
        result.append("</").append(TAG_NODE).append(">");
    }

    private void outputOpenTag(StringBuilder result, TreeNodeInfo info, Node selectedNode) {
        result.append("<").append(TAG_NODE);
        result.append(" ").append(ATTRIBUTE_ID).append("=\"").append(info.getId()).append("\"");
        if (info.getId() == selectedNode.getInfo().getId()) {
            result.append(" ").append(ATTRIBUTE_CURRENT).append("=\"true\"");
        }
        result.append(">");
    }

    private void outputNode(TreeNodeInfo info, StringBuilder result, Node selectedNode) {
        if (info.getName() != null) {
            putTag(result, TAG_NODE_NAME, info.getName());
        }
        if (info.getParentId() != null) {
            putTag(result, TAG_PARENT_URL_NODE_ID, info.getParentId().toString());
        }
        if (info.getUrlsInSubtree() != null) {
            putTag(result, TAG_NODE_URLS, info.getUrlsInSubtree().toString());
        }
        if (info.hasIntLinks()) {
            putTag(result, TAG_HAS_INT_LINKS, null);
        }
        if (info.hasExtLinks()) {
            putTag(result, TAG_HAS_EXT_LINKS, null);
        }
        if (info.hasChildren()) {
            putTag(result, TAG_HAS_CHILDREN, null);
        }
        if (info.getId() == selectedNode.getInfo().getId()) {
            addCurrentNodeXml(result);
        }
        if (info.getIndexCount() != null) {
            putLongTag(result, TAG_INDEX_COUNT, info.getIndexCount());
        }
        if (info.getUrlsTrend() != null) {
            putLongTag(result, TAG_URLS_TREND, info.getUrlsTrend());
        }
        if (info.getIndexCountTrend() != null) {
            putLongTag(result, TAG_INDEX_COUNT_TREND, info.getIndexCountTrend());
        }
    }

    protected void addCurrentNodeXml(StringBuilder result) {
    }
}
