package ru.yandex.wmconsole.data.wrappers;

import org.apache.commons.lang.StringUtils;

import ru.yandex.wmconsole.data.info.UrlAllowInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * <code>UrlAllowInfo</code> wrapper.
 *
 * @author ailyin
 */
public class UrlAllowInfoWrapper extends XmlDataWrapper<UrlAllowInfo> {
    public UrlAllowInfoWrapper(UrlAllowInfo info) {
        super(info, "allow-info");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, "url", data.getUrl());

        if (data.getError() != null) {
            putTag(result, "error-id", data.getError());
            return;
        }

        putBooleanTag(result, "allowed", data.getAllowInfo().isAllowed());
        if (!StringUtils.isEmpty(data.getAllowInfo().getRule())) {
            putTag(result, "rule", data.getAllowInfo().getRule());
        }
        if (!StringUtils.isEmpty(data.getAllowInfo().getChangedUrl())) {
            putTag(result, "changed-url", data.getAllowInfo().getChangedUrl());
        }
    }
}
