package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.UrlErrorsWithCodeInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
* User: senin
* Date: 22.03.2007
* Time: 15:47:26
*/
public class UrlErrorsWithCodeInfoWrapper extends XmlDataWrapper<UrlErrorsWithCodeInfo> {
    private static final String TAG_COUNT = "count";
    private static final String TAG_COUNT_TREND = "count_trend";
    private static final String TAG_SEVERITY = "severity";

    public UrlErrorsWithCodeInfoWrapper(UrlErrorsWithCodeInfo info) {
        super(info, "url-errors-with-code", "code", Integer.toString(info.getCode()));
    }
    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_COUNT, data.getCount());
        putIntegerTag(result, TAG_SEVERITY, data.getSeverity().getValue());
        putIntegerTag(result, TAG_COUNT_TREND, data.getTrend());
    }
}
