package ru.yandex.wmconsole.data.wrappers;

import java.util.Map;

import ru.yandex.wmconsole.data.SeverityEnum;
import ru.yandex.wmconsole.data.UserErrorOptions;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class UserErrorOptionsWrapper extends XmlDataWrapper<UserErrorOptions> {
    public UserErrorOptionsWrapper(UserErrorOptions data) {
        super(data, "error-options");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (Map.Entry<Integer, SeverityEnum> entry : data.getAllSeverities().entrySet()) {
            putTag(result, "error", entry.getValue().toString(), "code", Integer.toString(entry.getKey()));
        }
    }
}
