package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.UserHostRegionInfo;
import ru.yandex.wmtools.common.data.info.HostRegionInfo;
import ru.yandex.wmtools.common.data.wrappers.RegionInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;
import ru.yandex.wmtools.common.util.geobase.RegionInfoXmlSerializer;

/**
 * @author baton
 */
public class UserHostRegionInfoWrapper extends XmlDataWrapper<UserHostRegionInfo> {
    private static final String TAG_USER = "user";
    private static final String TAG_DESIRED_REGION = "desired-region";
    private static final String TAG_STATE = "state";
    private static final String TAG_UPDATE_DAY = "update-day";
    private static final String TAG_CHECK_DAY = "check-day";
    private static final String TAG_URL = "url";
    private static final String TAG_COMMENT = "comment";
    private static final String TAG_MODERATOR = "moderator";
    private static final String TAG_CONFIRMED = "confirmed";
    private static final String TAG_HOSTNAME = "hostname";

    public UserHostRegionInfoWrapper(UserHostRegionInfo info) {
        super(info, "user-region", "host-id", Long.toString(info.getHostId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_HOSTNAME, data.getHostName());
        putLongTag(result, TAG_USER, data.getUserId());

        putOpenTag(result, TAG_DESIRED_REGION);
        result.append(RegionInfoXmlSerializer.serialize(data.getUserClassificationInfo().getRegionInfo()));
        putCloseTag(result, TAG_DESIRED_REGION);

        putTag(result, TAG_STATE, data.getState().toString());
        putExtendedDateTimeTag(result, TAG_UPDATE_DAY, data.getUpdateDay());
        putExtendedDateTimeTag(result, TAG_CHECK_DAY, data.getCheckDay());
        putExtendedUserTag(result, TAG_MODERATOR, data.getModerator());
        putBooleanTag(result, TAG_CONFIRMED, data.isConfirmed());
        putHostnameTag(result, TAG_URL, data.getUrl());
        putTag(result, TAG_COMMENT, data.getComment());

        if (data.getRegions() != null) {
            for (HostRegionInfo hostRegionInfo : data.getRegions()) {
                new RegionInfoWrapper(hostRegionInfo.getRegionInfo(), hostRegionInfo.getRegionType()).toXml(result);
            }
        }
    }
}
