package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.data.wrappers.UserInfoWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 22.03.2007
 * Time: 21:43:03
 */
public class UserInfoExtendedWrapper extends UserInfoWrapper {
    private static final String TAG_OFFLINE_LINKS_ENABLED = "offline-links-enabled";
    private static final String TAG_NEED_FEEDBACK_CONFIRMATION = "need-feedback-confirmation";

    private final boolean offlineLinksEnabled;
    private final boolean needFeedbackConfirmation;

    @Override
    protected void doToXml(StringBuilder result) {
        if (offlineLinksEnabled) {
            putTag(result, TAG_OFFLINE_LINKS_ENABLED, null);
        }
        if (needFeedbackConfirmation) {
            putTag(result, TAG_NEED_FEEDBACK_CONFIRMATION, null);
        }
    }

    public UserInfoExtendedWrapper(WMUserInfo data, boolean offlineLinksEnabled, boolean needFeedbackConfirmation) {
        super(data);
        this.offlineLinksEnabled = offlineLinksEnabled;
        this.needFeedbackConfirmation = needFeedbackConfirmation;
    }
}
