package ru.yandex.wmconsole.data.wrappers;

import org.apache.commons.lang3.StringEscapeUtils;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.data.UserNotificationOptions;
import ru.yandex.wmconsole.data.info.NotificationOptionInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class UserNotificationOptionsWrapper extends XmlDataWrapper<UserNotificationOptions> {
    private static final String NOTIFICATION_PREFIX = "notification-";
    private static final String NOTIFICATION_TYPE_TAG = "type";
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_ROOT = "notification-options";
    private static final String TAG_DEFAULT = "default";
    private final boolean isDefault;

    public UserNotificationOptionsWrapper(UserNotificationOptions data, boolean isDefault) {
        super(data, TAG_ROOT);
        this.isDefault = isDefault;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (isDefault) {
            result.append("<").append(TAG_DEFAULT).append(">");
        }

        for (NotificationOptionInfo notificationOption : data.getNotificationOptions()) {
            /*putTag(result, NOTIFICATION_PREFIX + notificationOption.getNotificationChannel().name().toLowerCase(),
                    "true", NOTIFICATION_TYPE_TAG,
                    notificationOption.getNotificationType().getIntegerValue().toString());*/
            String name = StringEscapeUtils.escapeXml10(
                    NOTIFICATION_PREFIX + notificationOption.getNotificationChannel().name().toLowerCase()
            );
            String value = "true";
            String attrTypeName = NOTIFICATION_TYPE_TAG;
            String attrTypeValue = StringEscapeUtils.escapeXml10(
                    notificationOption.getNotificationType().toString()
            );
            String attrActiveName = TAG_ACTIVE;
            String attrActiveValue;
            //todo remove dirty hack
            if (
                    ((notificationOption.getNotificationType().equals(NotificationTypeEnum.GLOBAL_MESSAGE.getValue()))
                    || (notificationOption.getNotificationType().equals(NotificationTypeEnum.PERSONAL_MESSAGE.getValue())))
                            && (notificationOption.getNotificationChannel() == NotificationChannelEnum.MESSAGE)) {
                attrActiveValue = "no";
            } else {
                attrActiveValue = "yes";
            }
            result.append("<").append(name).append(" ")
                    .append(attrTypeName).append("=\"").append(attrTypeValue).append("\"").append(" ")
                    .append(attrActiveName).append("=\"").append(attrActiveValue).append("\"")
                    .append(">").append(value).append("</").append(name).append(">");
        }

        if (isDefault) {
            result.append("</").append(TAG_DEFAULT).append(">");
        }
    }
}
