package ru.yandex.wmconsole.data.wrappers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.verification.VerificationIdentifier;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author baton
 * @author ailyin
 */
public class UsersHostsInfoWrapper extends XmlDataWrapper<UsersHostsInfo> {
    private static final String TAG_UID = "uid";
    private static final String TAG_STATE = "state";
    private static final String TAG_UIN = "uin";
    private static final String TAG_TYPE = "type";
    private static final String TAG_POSSIBLE_TO_CANCEL = "possible-to-cancel";
    private static final String TAG_DATE = "date";
    private static final String TAG_FAULT_LOG = "fault-log";

    private static final Set<String> ACCOUNT_INFO_KEYS = new HashSet<String>(Arrays.asList(
            "login", "fio", "nickname", "sex", "country", "region", "city", "reg_date"));

    public UsersHostsInfoWrapper(UsersHostsInfo info) {
        super(info, "verification");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new BlackBoxUserInfoWrapper(data.getUserInfo()).toXml(result);
        putTag(result, TAG_STATE, data.getVerificationState().toString());
        putTag(result, TAG_UIN, VerificationIdentifier.valueOf(data.getVerificationUin()).toString());
        putTag(result, TAG_TYPE, data.getVerificationType().toString());
        putBooleanTag(result, TAG_POSSIBLE_TO_CANCEL, data.getVerificationType().isPossibleToCancel());
        putDateTag(result, TAG_DATE, data.getVerificationDate());
        putTag(result, TAG_FAULT_LOG, data.getVerifyFaultLog());
    }
}
