package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.info.UsersHostsVerificationInfo;
import ru.yandex.wmconsole.verification.VerificationIdentifier;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class UsersHostsVerificationInfoWrapper extends XmlDataWrapper<UsersHostsVerificationInfo> {
    private static final String TAG_USER_GAVE = "user-gave";
    private static final String TAG_USER_GOT = "user";
    private static final String TAG_UIN = "uin";
    private static final String TAG_TYPE = "type";
    private static final String TAG_POSSIBLE_TO_CANCEL = "possible-to-cancel";
    private static final String TAG_DATE = "date";
    private static final String TAG_FAULT_LOG = "fault-log";
    private static final String TAG_MAY_REDELEGATE = "may-redelegate";
    private static final String TAG_HOST_ADDED = "host-added";
    private static final String TAG_STATE = "state";
    private static final String TAG_HTTP_CODE = "http-code";


    public UsersHostsVerificationInfoWrapper(UsersHostsVerificationInfo info) {
        super(info, "verification");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        new BlackBoxUserInfoWrapper(data.getUserGotInfo(), TAG_USER_GOT).toXml(result);
        putTag(result, TAG_TYPE, data.getVerificationType().toString());
        putBooleanTag(result, TAG_MAY_REDELEGATE, data.isMayRedelegate());
        putBooleanTag(result, TAG_HOST_ADDED, data.isHostAdded());
        putBooleanTag(result, TAG_POSSIBLE_TO_CANCEL, data.getVerificationType().isPossibleToCancel());
        putDateTag(result, TAG_DATE, data.getVerificationDate());

        if (data.getUserGaveInfo() != null) {
            new BlackBoxUserInfoWrapper(data.getUserGaveInfo(), TAG_USER_GAVE).toXml(result);
        }

        if (data.getVerificationUin() != null) {
            if (data.getHttpCode() != null) {
                final VerificationStateEnum state = calculateVerificationStateWithHttpCode(data.getVerificationState());
                putTag(result, TAG_STATE, state.name());
                putIntegerTag(result, TAG_HTTP_CODE, data.getHttpCode());
            } else {
                putTag(result, TAG_STATE, data.getVerificationState().name());
            }
            putTag(result, TAG_FAULT_LOG, data.getVerifyFaultLog());
            putTag(result, TAG_UIN, VerificationIdentifier.valueOf(data.getVerificationUin()).toString());
        }
    }

    private VerificationStateEnum calculateVerificationStateWithHttpCode(VerificationStateEnum state) {
        switch (state) {
            case TXT_FILE_IO_EXCEPTION: return VerificationStateEnum.TXT_FILE_HTTP_CODE;
            case HTML_FILE_IO_EXCEPTION: return VerificationStateEnum.HTML_FILE_HTTP_CODE;
            case META_TAG_IO_EXCEPTION: return VerificationStateEnum.META_TAG_HTTP_CODE;
            default: return state;
        }
    }
}
