package ru.yandex.wmconsole.data.wrappers;

import java.util.LinkedList;
import java.util.List;

import ru.yandex.wmconsole.data.info.VirusInfo;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class VirusInfoWrapper extends XmlDataWrapper<VirusInfo> {
    private static final String TAG_ROOT = "virus";
    private static final String TAG_URL = "url";
    private static final String TAG_NAME = "name";
    private static final String TAG_CHAIN = "virus-chain";

    public VirusInfoWrapper(VirusInfo data) {
        super(data, TAG_ROOT);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getUrl() != null) {
            putTag(result, TAG_URL, data.getUrl());
        }

        if (data.getName() != null && data.getName().length() >= 2) {
            putTag(result, TAG_NAME, data.getName().substring(1, data.getName().length() - 1));
        }

        new DateWrapper(data.getLastCheck()).toXml(result);

        if (data.getVirusChain() != null) {
            final List<StringWrapper> wrappers = new LinkedList<StringWrapper>();
            for (String url : data.getVirusChain()) {
                wrappers.add(new StringWrapper(url, TAG_URL));
            }
            new XmlConvertableCollectionWrapper(wrappers, TAG_CHAIN).toXml(result);
        }
    }
}
