package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.RecheckInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 17.04.13
 * Time: 19:57
 */
public class VirusRecheckInfoWrapper extends XmlDataWrapper<RecheckInfo> {

    private static final String TAG_RECHECK_INFO = "recheck-info";
    private static final String TAG_RECHECK_STATE = "recheck-state";
    private static final String TAG_RECHECK_DATE = "recheck-date";

    public VirusRecheckInfoWrapper(RecheckInfo data) {
        super(data, TAG_RECHECK_INFO);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getRecheckState() != null) {
            putTag(result, TAG_RECHECK_STATE, data.getRecheckState().name());
        }
        putDateTag(result, TAG_RECHECK_DATE, data.getDate());
    }
}
