package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.WMCTopInfoItem;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.09.2008
 * Time: 21:05:13
 */
public class WMCTopInfoItemWrapper extends XmlDataWrapper<WMCTopInfoItem> {
    private static final String ATTRIBUTE_QUERY_ID = "query_id";
    public static final String TAG_QUERY = "query";
    public static final String TAG_CLICKS = "clicks";
    public static final String TAG_SHOWS = "shows";
    public static final String TAG_POSITION = "position";
    private static final String TAG_TOP_INFO = "top-info";
    private static final String TAG_SHOWS_TOP_RANK = "shows-top-rank";
    private static final String TAG_CLICKS_TOP_RANK = "clicks-top-rank";
    private static final String TAG_IS_CUSTOM = "is-custom";
    private static final String TAG_HAS_HISTORY = "has-history";

    public WMCTopInfoItemWrapper(WMCTopInfoItem info) {
        super(info, TAG_TOP_INFO, ATTRIBUTE_QUERY_ID, Long.toString(info.getQueryId()));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        if (data.getQuery() != null) {
            putTag(result, TAG_QUERY, data.getQuery());
        }

        putTag(result, TAG_SHOWS, Integer.toString(data.getShows()));
        putTag(result, TAG_CLICKS, Integer.toString(data.getClicks()));
        putBooleanTag(result, TAG_IS_CUSTOM, data.isCustom());
        putBooleanTag(result, TAG_HAS_HISTORY, data.hasHistory());

        if (data.getShowsTopRank() != null) {
            putIntegerTag(result, TAG_SHOWS_TOP_RANK, data.getShowsTopRank() + 1);
        }

        if (data.getClicksTopRank() != null) {
            putIntegerTag(result, TAG_CLICKS_TOP_RANK, data.getClicksTopRank() + 1);
        }

        if (data.getPosition() != null) {
            putTag(result, TAG_POSITION, Integer.toString((int) (data.getPosition() + 1)));
        }
    }
}
