package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.WMCTopInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfoItem;
import ru.yandex.wmtools.common.data.info.TopInfoItem;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: krupsky
 * Date: 08.08.2008
 * Time: 20:22:12
 */
public class WMCTopInfoWrapper extends XmlDataWrapper<WMCTopInfo> {
    private static final String TAG_TOTAL_SHOWS_COUNT = "total-shows-count";
    private static final String TAG_TOTAL_CLICKS_COUNT = "total-clicks-count";
    private static final String TAG_TOP_QUERIES = "top-queries";
    private static final String TAG_TOP_SHOWS_PERCENT = "top-shows-percent";
    private static final String TAG_TOP_CLICKS_PERCENT = "top-clicks-percent";
    private static final String TAG_TOP_ITEMS = "top-items";
    private static final String TAG_ERROR = "error";

    private final double topShowsPercent;
    private final double topClicksPercent;

    private WMCTopInfoWrapper(WMCTopInfo info, double topShowsPercent, double topClicksPercent) {
        super(info, TAG_TOP_QUERIES);
        this.topShowsPercent = topShowsPercent;
        this.topClicksPercent = topClicksPercent;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        XmlConvertableCollectionWrapper.wrap(
                data.getTopItems(),
                WMCTopInfoItemWrapper.class,
                TAG_TOP_ITEMS
        ).toXml(result);
        putTag(result, TAG_TOTAL_SHOWS_COUNT, Integer.toString(data.getTotalsInfo().getTotalShows()));
        putTag(result, TAG_TOP_SHOWS_PERCENT, Double.toString(topShowsPercent));
        putTag(result, TAG_TOTAL_CLICKS_COUNT, Integer.toString(data.getTotalsInfo().getTotalClicks()));
        putTag(result, TAG_TOP_CLICKS_PERCENT, Double.toString(topClicksPercent));

        if (data.getError() != null) {
            putTag(result, TAG_ERROR, data.getError().toString());
        }
    }

    public static WMCTopInfoWrapper create(WMCTopInfo info) {
        int topShowsPercent = 0;
        if (info.getTotalsInfo().getTotalShows() > 0) {
            for (TopInfoItem topItem : info.getTopItems()) {
                topShowsPercent += topItem.getShows();
            }
            topShowsPercent = (100 * topShowsPercent) / info.getTotalsInfo().getTotalShows();
        }

        int topClicksPercent = 0;
        if (info.getTotalsInfo().getTotalClicks() > 0) {
            for (WMCTopInfoItem topClicksItem : info.getTopItems()) {
                topClicksPercent += topClicksItem.getClicks();
            }
            topClicksPercent = (100 * topClicksPercent) / info.getTotalsInfo().getTotalClicks();
        }

        return new WMCTopInfoWrapper(info, topShowsPercent, topClicksPercent);
    }
}
