package ru.yandex.wmconsole.data.wrappers;

import ru.yandex.wmconsole.data.info.XMLSerpLinkInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class XMLSerpLinkWrapper extends XmlDataWrapper<XMLSerpLinkInfo> {
    private static final String TAG_PAGE = "serplink";
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_NAME = "name";

    public XMLSerpLinkWrapper(XMLSerpLinkInfo data) throws UnsupportedEncodingException {
        super(data, TAG_PAGE, ATTRIBUTE_URL, URLEncoder.encode(data.getUrl(), "windows-1251"),
                ATTRIBUTE_NAME, data.getName());
    }

    @Override
    protected void doToXml(StringBuilder result) {
    }
}
