package ru.yandex.wmconsole.data.wrappers.api;

import ru.yandex.wmconsole.data.info.UrlErrorsWithCodeInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ApiErrorInfoWrapper extends XmlDataWrapper<UrlErrorsWithCodeInfo> {
    private static final String TAG_COUNT = "count";
    private static final String TAG_SEVERITY = "severity";

    public ApiErrorInfoWrapper(UrlErrorsWithCodeInfo info) {
        super(info, "url-errors-with-code", "code", Integer.toString(Math.abs(info.getCode())));
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_COUNT, data.getCount());
        putTag(result, TAG_SEVERITY, data.getSeverity().toString());
    }
}
