package ru.yandex.wmconsole.data.wrappers.api;

import ru.yandex.wmconsole.data.api.ApiVerificationState;
import ru.yandex.wmconsole.data.info.api.ApiExtendedHostInfo;

/**
 * @author ailyin
 */
public class ApiExtendedHostInfoWrapper extends ApiHostInfoWrapper<ApiExtendedHostInfo> {
    private static final String TAG_URL_ERRORS = "url-errors";
    private static final String TAG_INTERNAL_LINKS_COUNT = "internal-links-count";
    private static final String TAG_LINKS_COUNT = "links-count";

    public ApiExtendedHostInfoWrapper(ApiExtendedHostInfo info) {
        super(info);
    }

    @Override
    protected void doToXml(StringBuilder result) {
        super.doToXml(result);

        //todo (minor) following conditionals duplicate base class logic
        ApiVerificationState verState = ApiVerificationState.getByVerifcationStateAndType(
                data.getVerificationState(), data.getVerificationType());
        if (!ApiVerificationState.VERIFIED.equals(verState)) {
            return;
        }

        long urlCount = data.getUrls() == null ? 0 : data.getUrls();
        long indexCount = data.getIndexCount() == null ? 0 : data.getIndexCount();

        if (urlCount < indexCount) {
            urlCount = indexCount;
        }

        boolean indexed = urlCount > 0;
        if (!indexed) {
            return;
        }

        //todo check if nulls are possible
        putLongTag(result, TAG_URL_ERRORS, data.getUrlErrors());
        putLongTag(result, TAG_INTERNAL_LINKS_COUNT, data.getInternalLinksCount());
        putLongTag(result, TAG_LINKS_COUNT, data.getLinksCount());
    }
}
