package ru.yandex.wmconsole.data.wrappers.api;

import ru.yandex.wmconsole.data.info.WMCTopInfo;
import ru.yandex.wmconsole.data.info.WMCTopInfoItem;
import ru.yandex.wmtools.common.data.info.TopInfoItem;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ApiTopInfoWrapper extends XmlDataWrapper<WMCTopInfo> {
    private static final String TAG_TOTAL_SHOWS_COUNT = "total-shows-count";
    private static final String TAG_TOTAL_CLICKS_COUNT = "total-clicks-count";
    private static final String TAG_TOP_SHOWS_PERCENT = "top-shows-percent";
    private static final String TAG_TOP_CLICKS_PERCENT = "top-clicks-percent";

    private static final String TAG_QUERY = "query";
    private static final String TAG_COUNT = "count";
    private static final String TAG_POSITION = "position";
//    private static final String TAG_TOP_INFO = "top-info";
    private static final String TAG_SHOWS_TOP_RANK = "shows-top-rank";
    private static final String TAG_CLICKS_TOP_RANK = "clicks-top-rank";
    private static final String TAG_IS_CUSTOM = "is-custom";

    private final WMCTopInfo showsTopInfo;
    private final WMCTopInfo clicksTopInfo;

    public ApiTopInfoWrapper(WMCTopInfo showsTopInfo, WMCTopInfo clicksTopInfo) {
        super(null, "top-queries");
        this.showsTopInfo = showsTopInfo;
        this.clicksTopInfo = clicksTopInfo;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putIntegerTag(result, TAG_TOTAL_SHOWS_COUNT, showsTopInfo.getTotalsInfo().getTotalShows());
        putTag(result, TAG_TOP_SHOWS_PERCENT, Double.toString(getShowsPercent(showsTopInfo)));

        result.append("<top-shows>");
        for (WMCTopInfoItem item : showsTopInfo.getTopItems()) {
            result.append("<top-info>");

            if (item.getQuery() != null) {
                putTag(result, TAG_QUERY, item.getQuery());
            }
            putIntegerTag(result, TAG_COUNT, item.getShows());
            if (item.getPosition() != null) {
                putIntegerTag(result, TAG_POSITION, (int) (item.getPosition() + 1));
            }
            //todo percent
            //todo output clicks rank?
            if (item.getShowsTopRank() != null) {
                putIntegerTag(result, TAG_SHOWS_TOP_RANK, item.getShowsTopRank() + 1);
            }
            if (item.getClicksTopRank() != null) {
                putIntegerTag(result, TAG_CLICKS_TOP_RANK, item.getClicksTopRank() + 1);
            }
            putBooleanTag(result, TAG_IS_CUSTOM, item.isCustom());

            result.append("</top-info>");
        }
        result.append("</top-shows>");

        putIntegerTag(result, TAG_TOTAL_CLICKS_COUNT, clicksTopInfo.getTotalsInfo().getTotalClicks());
        putTag(result, TAG_TOP_CLICKS_PERCENT, Double.toString(getClicksPercent(clicksTopInfo)));

        result.append("<top-clicks>");
        for (WMCTopInfoItem item : clicksTopInfo.getTopItems()) {
            result.append("<top-info>");

            if (item.getQuery() != null) {
                putTag(result, TAG_QUERY, item.getQuery());
            }
            putIntegerTag(result, TAG_COUNT, item.getClicks());
            if (item.getPosition() != null) {
                putIntegerTag(result, TAG_POSITION, (int) (item.getPosition() + 1));
            }
            //todo percent
            //todo output shows rank?
            if (item.getShowsTopRank() != null) {
                putIntegerTag(result, TAG_SHOWS_TOP_RANK, item.getShowsTopRank() + 1);
            }
            if (item.getClicksTopRank() != null) {
                putIntegerTag(result, TAG_CLICKS_TOP_RANK, item.getClicksTopRank() + 1);
            }
            putBooleanTag(result, TAG_IS_CUSTOM, item.isCustom());

            result.append("</top-info>");
        }
        result.append("</top-clicks>");
    }

    private double getShowsPercent(WMCTopInfo info) {
        double result = 0;
        if (info.getTotalsInfo().getTotalShows() > 0) {
            for (TopInfoItem topItem : info.getTopItems()) {
                result += topItem.getShows();
            }
            result = (100 * result) / info.getTotalsInfo().getTotalShows();
        }
        return result;
    }

    private double getClicksPercent(WMCTopInfo info) {
        double result = 0;
        if (info.getTotalsInfo().getTotalClicks() > 0) {
            for (WMCTopInfoItem topItem : info.getTopItems()) {
                result += topItem.getClicks();
            }
            result = (100 * result) / info.getTotalsInfo().getTotalClicks();
        }
        return result;
    }
}
