package ru.yandex.wmconsole.data.wrappers.api;

import ru.yandex.wmconsole.data.api.ApiVerificationState;
import ru.yandex.wmconsole.data.api.ApiVerificationType;
import ru.yandex.wmconsole.data.info.api.ApiUsersHostsInfo;
import ru.yandex.wmconsole.verification.VerificationIdentifier;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author ailyin
 */
public class ApiUsersHostsInfoWrapper extends XmlDataWrapper<ApiUsersHostsInfo> {
    private static final String TAG_NAME = "name";
    private static final String TAG_TYPE = "type";
    private static final String TAG_POSSIBLE_TO_CANCEL = "possible-to-cancel";
    private static final String TAG_DATE = "date";
    private static final String TAG_UIN = "uin";
    private static final String TAG_OTHER_USERS = "other-users-exist";

    public ApiUsersHostsInfoWrapper(ApiUsersHostsInfo info) {
        super(info, "host");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_NAME, data.getHostname());
        ApiVerificationState state = null;
        if (VerificationTypeEnum.CHEAT.equals(data.getVerificationType())) {
            result.append("<verification state=\"VERIFIED\">");
        } else {
            state = ApiVerificationState.getByVerifcationStateAndType(
                    data.getVerificationState(), data.getVerificationType());
            result.append("<verification state=\"" + state.toString() + "\">");
        }
        if (VerificationTypeEnum.CHEAT.equals(data.getVerificationType()) || ApiVerificationState.VERIFIED.equals(state)) {
            if (VerificationTypeEnum.CHEAT.equals(data.getVerificationType())) {
                putTag(result, TAG_TYPE, "CHEAT");
            } else {
                putTag(result, TAG_TYPE, ApiVerificationType.getByVerificationType(data.getVerificationType()).toString());
            }
            putBooleanTag(result, TAG_POSSIBLE_TO_CANCEL, data.getVerificationType().isPossibleToCancel());
            putDateTimeTag(result, TAG_DATE, data.getVerificationDate());
        } else {
            putTag(result, TAG_UIN, VerificationIdentifier.valueOf(data.getVerificationUin()).toString());
        }
        result.append("</verification>");

        if (VerificationTypeEnum.CHEAT.equals(data.getVerificationType()) || ApiVerificationState.VERIFIED.equals(state)) {
            if (data.areOtherUsersExist()) {
                putTag(result, TAG_OTHER_USERS, null);
            }
        }
    }
}
