package ru.yandex.wmconsole.data.wrappers.draft.message;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.draft.messages.DraftMessageFoundHostInfo;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmtools.common.data.wrappers.LongWrapper;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 23.04.13
 * Time: 12:56
 */
public class DraftMessageCheckResultWrapper extends XmlDataWrapper<Object> {
    private static final String TAG_CHECK_RESULT = "check-result";
    private static final String TAG_HOST_LIST = "host-list";
    private static final String TAG_HOST = "host";
    private static final String TAG_NOT_SUCCESSFUL = "not-successful";
    private static final String TAG_USER = "user";
    private static final String TAG_USER_LIST = "user-list";

    private final Map<String, DraftMessageFoundHostInfo> originalToFoundHostInfo;
    private final Set<Long> userIds;
    private final List<String> notSuccessful;
    private final boolean verbose;

    public DraftMessageCheckResultWrapper(
            Map<String, DraftMessageFoundHostInfo> originalToFoundHostInfo,
            Set<Long> userIds,
            List<String> notSuccessful,
            boolean verbose) {
        super(null, TAG_CHECK_RESULT);
        this.originalToFoundHostInfo = originalToFoundHostInfo;
        this.userIds =  userIds;
        this.notSuccessful = notSuccessful;
        this.verbose = verbose;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        // host list
        if (verbose) {
            List<XmlConvertable> hostWrappers = new LinkedList<XmlConvertable>();
            for (Map.Entry<String, DraftMessageFoundHostInfo> entry : originalToFoundHostInfo.entrySet()) {
                String originalHostName = entry.getKey();
                hostWrappers.add(new DraftMessageFoundHostInfoWrapper(TAG_HOST, originalHostName, entry.getValue()));
            }
            new XmlConvertableCollectionWrapper(hostWrappers, TAG_HOST_LIST).toXml(result);
        }

        // user list
        List<XmlConvertable> userWrappers = new LinkedList<XmlConvertable>();
        for (Long userId : userIds) {
            userWrappers.add(new LongWrapper(TAG_USER, userId));
        }
        new XmlConvertableCollectionWrapper(userWrappers, TAG_USER_LIST).toXml(result);

        // not successful hosts
        List<XmlDataWrapper> notSuccessfulWrappers = new LinkedList<XmlDataWrapper>();
        for (String host: notSuccessful) {
            notSuccessfulWrappers.add(new StringWrapper(host, TAG_HOST));
        }
        new XmlConvertableCollectionWrapper(notSuccessfulWrappers, TAG_NOT_SUCCESSFUL).toXml(result);
    }
}
