package ru.yandex.wmconsole.data.wrappers.draft.message;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.data.info.draft.messages.DraftMessageFoundHostInfo;
import ru.yandex.wmtools.common.data.wrappers.LongWrapper;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

import java.util.LinkedList;
import java.util.List;

/**
 * User: azakharov
 * Date: 23.04.13
 * Time: 12:53
 */
public class DraftMessageFoundHostInfoWrapper extends XmlDataWrapper<DraftMessageFoundHostInfo> {

    private static final String TAG_ORIGINAL_NAME = "original-name";
    private static final String TAG_FOUND_NAME = "found-name";
    private static final String TAG_USER = "user";
    private static final String TAG_USER_LIST = "user-list";

    private final String originalHostName;
    private final String foundHostName;
    private final List<UsersHostsInfo> usersHosts;

    public DraftMessageFoundHostInfoWrapper(String name, String originalHostName, DraftMessageFoundHostInfo foundHostInfo) {
        super(null, name);
        this.originalHostName = originalHostName;
        this.foundHostName = foundHostInfo.getHostName();
        this.usersHosts = foundHostInfo.getUsersHostsInfoList();
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putTag(result, TAG_ORIGINAL_NAME, originalHostName);
        putTag(result, TAG_FOUND_NAME, foundHostName);

        List<XmlDataWrapper> userWrappers = new LinkedList<XmlDataWrapper>();
        for (UsersHostsInfo uhi : usersHosts) {
            userWrappers.add(new LongWrapper(TAG_USER, uhi.getUserId()));
        }
        XmlConvertable userListWrapper = new XmlConvertableCollectionWrapper(userWrappers, TAG_USER_LIST);
        userListWrapper.toXml(result);
    }
}
