package ru.yandex.wmconsole.data.wrappers.graph;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.wmconsole.data.info.graph.GraphDay;
import ru.yandex.wmconsole.data.info.graph.GraphPoint;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author yakushev
 */
public class GraphDayWrapper extends XmlDataWrapper<GraphDay> {
    private final List<GraphPointWrapper> pointWrappers;

    public GraphDayWrapper(GraphDay data) {
        super(data, "day", "date", getDateFormat().format(data.getDate()));

        this.pointWrappers = new ArrayList<GraphPointWrapper>();
        for (GraphPoint point : data.getPoints()) {
            pointWrappers.add(new GraphPointWrapper(point));
        }
    }

    @Override
    protected void doToXml(StringBuilder result) {
        for (GraphPointWrapper pointWrapper : pointWrappers) {
            pointWrapper.toXml(result);
        }
    }
}
