package ru.yandex.wmconsole.data.wrappers.graph;

import org.apache.commons.lang.StringUtils;

import ru.yandex.wmconsole.data.info.graph.GraphSystem;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author yakushev
*/
public class GraphSystemWrapper extends XmlDataWrapper<GraphSystem> {
    public GraphSystemWrapper(GraphSystem data) {
        super(data, "system");

        addAttribute("name", data.getName());

        if (data.isSelected()) {
            addAttribute("selected", String.valueOf(true));
        }

        String color = data.getColor();
        if (!StringUtils.isEmpty(color)) {
            addAttribute("color", color);
        }
    }

    @Override
    protected void doToXml(StringBuilder result) {
    }
}
