package ru.yandex.wmconsole.data.wrappers.graph;

import java.util.List;

import ru.yandex.wmconsole.data.info.graph.Graph;
import ru.yandex.wmconsole.data.info.graph.GraphParam;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author yakushev
 */
public class GraphWrapper extends XmlDataWrapper<Graph> {
    private final XmlConvertableCollectionWrapper systemWrappers;
    private final XmlConvertableCollectionWrapper dayGroupWrappers;

    public GraphWrapper(Graph data) {
        super(data, "graph");

        List<GraphParam> params = data.getParams();
        for (GraphParam param : params) {
            addAttribute(param.getName(), param.getValue());
        }

        this.systemWrappers = XmlConvertableCollectionWrapper.wrap(
                data.getSystems(), GraphSystemWrapper.class, "systems");

        this.dayGroupWrappers = XmlConvertableCollectionWrapper.wrap(
                data.getDays(), GraphDayWrapper.class, "day-group");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        systemWrappers.toXml(result);
        dayGroupWrappers.toXml(result);
    }
}
