package ru.yandex.wmconsole.data.xmlsearch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.wmtools.common.data.xmlsearch.AbstractRequest;

/**
 * @author avhaliullin
 */
public class RegionSearchRequest extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(RegionSearchRequest.class);

    private static final int MAX_DOC_NUM = 1000;
    private static final int MAX_PAGE_SIZE = 25;

    private final String query;
    private final long region;
    private final int pageSize;
    private final int pageNum;

    public RegionSearchRequest(String query, long region, int pageNum, int pageSize) {
        this.query = query;
        this.region = region;
        this.pageSize = Math.abs(Math.min(pageSize, MAX_PAGE_SIZE));
        int ps = Math.max(pageSize, 1);
        int pn = Math.max(pageNum, 0);
        this.pageNum = Math.min(pn, MAX_DOC_NUM / ps - 1);
    }

    @Override
    protected String getQueryText() {
        log.debug("regionsCompare query:" + query);
        return query;
    }

    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_DEEP;
    }

    @Override
    protected String getGroupByAttr() {
        return GROUP_BY_ATTR_D;
    }

    @Override
    protected int getPageNum() {
        return pageNum;
    }

    @Override
    protected int getPageSize() {
        return pageSize;
    }

    @Override
    public String getUrlParams() {
        return "lr=" + region;
    }
}
