package ru.yandex.wmconsole.data.xmlsearch;

import ru.yandex.wmtools.common.data.xmlsearch.AbstractRequest;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class SerpLinksRequest extends AbstractRequest {
    private final String sectionName;

    public SerpLinksRequest(String sectionName) {
        this.sectionName = sectionName;
    }

    @Override
    protected String getQueryText() throws InternalException {
        return "url:" + sectionName;
    }

    @Override
    protected String getGroupByAttr() {
        return GROUP_BY_ATTR_D;
    }

    @Override
    protected String getGroupByMode() {
        return GROUP_BY_MODE_DEEP;
    }

    @Override
    protected int getPageNum() {
        return 0;
    }

    @Override
    protected int getPageSize() {
        return 10;
    }

    @Override
    public String getUrlParams() throws InternalException {
        return "rearr=AntiDup_off";
    }
}
