package ru.yandex.wmconsole.error;

import ru.yandex.wmtools.common.error.IUserProblem;

/**
 * API client problems.
 * New values should NOT be added prior to updating API documentation.
 *
 * @author ailyin
 */
public enum ClientProblem implements IUserProblem {
    //authorization issues
    BAD_FORMAT,
    EXPIRED_TOKEN,
    WRONG_USER_ID,
    INVALID_TOKEN,

    HOST_NOT_OWNED_BY_USER,
    HOST_NOT_VERIFIED_BY_USER,
    NO_DATA_FOR_HOST,        // host is not indexed by main robot
    HOST_NOT_INDEXED,        // host is not indexed by main robot nor by fast robot
    REQUIRED_PARAM_MISSED,
    ILLEGAL_VALUE_TYPE,
    ILLEGAL_PARAM_VALUE,
    INVALID_URL,
    ILLEGAL_PORT_NUMBER,   //todo same as INVALID_URL?
    HOST_IS_MIRROR,
    HOST_IS_MIRROR_ALREADY_ADDED, // todo: azakharov make it visible in api after api release
    TOO_MANY_MIRRORS_FOR_HOST,
    MIRROR_IS_NOT_ALLOWED,
    HOST_NOT_AVAILABLE,
    URL_RETURNED_WRONG_CODE,      // todo: azakharov make it visible in api after api release
    USERS_HOSTS_COUNT_LIMIT_EXCEEDED,
    HOST_ALREADY_ADDED,
    GZIP_STREAM_READ_ERROR,
    USER_EXCEEDED_NOT_VERIFIED_HOSTS_LIMIT,
    URL_REDIRECTED,
    CYCLIC_REDIRECT,              // todo: azakharov make it visible in api after api release
    REPORT_LIMIT_EXCEEDED,
    REPORT_NOT_OWNED_BY_USER,
    REPORT_NOT_READY,
    URL_IS_NOT_FROM_HOST,
    URL_IS_NOT_FROM_HOST_REDIR,

    INTERNAL_ERROR,

    // Sitemaps
    SITEMAP_NOT_FOUND,

    // Originals
    NOT_ENOUGH_TIC,
    ORIGINALS_LIMIT_EXCEEDED,
    ORIGINALS_TEXT_TOO_SHORT,
    ORIGINALS_TEXT_TOO_LONG,
    ORIGINALS_TEXT_ALREADY_ADDED,

    ;

    @Override
    public Integer getId() {
        return null;
    }
}
