package ru.yandex.wmconsole.error;

import ru.yandex.wmtools.common.error.IExtraTagName;

/**
 * @author baton
 */
public enum WMCExtraTagNameEnum implements IExtraTagName {
    ORIGINAL_HOST_NAME("host-name"),
    ORIGINAL_HOST_ID("host-id"),
    MAIN_MIRROR("main-mirror-url"),
    MAIN_MIRROR_HOST_ID("main-mirror-host-id"),
    WWW_MIRROR_HOST_NAME("www-mirror-name"),
    WWW_MIRROR_STATUS("www-mirror-status"),
    WWW_MIRROR_DESIRED_MAIN("www-mirror-desired-main"),
    HTTP_CODE("http-code"),
    USER_MIRROR_URL("user-mirror"),
    CANT_CHANGE_MIRROR_REASON("cant-change-mirror-reason"),
    REDIRECT_TARGET("redirect-target"),
    REDIRECT_SOURCE("redirect-source"),
    EXTENDED_HTTP_CODE("extended-http-code"),
    SUGGESTED_HOST_ID("suggested-host-id"),
    SUGGESTED_HOST_NAME("suggested-host-name"),
    LAST_MODIFIED("last-modified");

    private final String name;

    WMCExtraTagNameEnum(String name) {
        this.name = name;
    }

    WMCExtraTagNameEnum() {
        this.name = this.toString().toLowerCase();
    }

    @Override
    public String getName() {
        return name;
    }
}
