package ru.yandex.wmconsole.service;

import java.net.URL;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmtools.common.data.xmlsearch.UrlsRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.IService;
import ru.yandex.wmtools.common.service.IndexInfoService;

/**
 * Abstract class for classes like <code>AddUrlService</code>, <code>DelUrlService</code>, etc.
 *
 * @author ailyin
 */
public abstract class AbstractUrlService implements IService {
    private IndexInfoService indexInfoService;
    private IndexInfoService trIndexInfoService;
    private IndexInfoService comIndexInfoService;
    private DispatcherHttpService dispatcherHttpService;

    protected DispatcherHttpService getDispatcherHttpService() {
        return dispatcherHttpService;
    }

    protected IndexInfoService.IndexedResult checkIfIndexedCom(URL url) throws UserException, InternalException {
        String path = url.getFile();    // url path AND query
        if (path.endsWith("/")) {       // xmlsearch doesn't understand urls with '/' at the end
            path = path.substring(0, path.length() - 1);
        }

        XmlSearchRequest request = new UrlsRequest(url.getAuthority(), path, 0, 10);
        return comIndexInfoService.checkIfIndexed(request);
    }


    protected IndexInfoService.IndexedResult checkIfIndexedTr(URL url) throws UserException, InternalException {
        String path = url.getFile();    // url path AND query
        if (path.endsWith("/")) {       // xmlsearch doesn't understand urls with '/' at the end
            path = path.substring(0, path.length() - 1);
        }

        XmlSearchRequest request = new UrlsRequest(url.getAuthority(), path, 0, 10);
        return trIndexInfoService.checkIfIndexed(request);
    }

    protected boolean isIndexedTr(URL url) throws UserException, InternalException {
        IndexInfoService.IndexedResult indexedResult = checkIfIndexedTr(url);
        return (indexedResult != null) && (indexedResult == IndexInfoService.IndexedResult.INDEXED);
    }

    /*
     * Returns false if url is not indexed or fake, true otherwise.
     */
    protected boolean isIndexed(URL url) throws UserException, InternalException {
        IndexInfoService.IndexedResult indexedResult = checkIfIndexed(url);
        return (indexedResult != null) && (indexedResult == IndexInfoService.IndexedResult.INDEXED);
    }

    /*
     * There are three possible results: indexed, not indexed and fake.
     */
    protected IndexInfoService.IndexedResult checkIfIndexed(URL url) throws UserException, InternalException {
        String path = url.getFile();    // url path AND query
        if (path.endsWith("/")) {       // xmlsearch doesn't understand urls with '/' at the end
            path = path.substring(0, path.length() - 1);
        }

        XmlSearchRequest request = new UrlsRequest(url.getAuthority(), path, 0, 10);
        return indexInfoService.checkIfIndexed(request);
    }

    @Required
    public void setDispatcherHttpService(DispatcherHttpService dispatcherHttpService) {
        this.dispatcherHttpService = dispatcherHttpService;
    }

    @Required
    public void setTrIndexInfoService(IndexInfoService trIndexInfoService) {
        this.trIndexInfoService = trIndexInfoService;
    }

    @Required
    public void setIndexInfoService(IndexInfoService indexInfoService) {
        this.indexInfoService = indexInfoService;
    }

    @Required
    public void setComIndexInfoService(IndexInfoService comIndexInfoService) {
        this.comIndexInfoService = comIndexInfoService;
    }
}
