package ru.yandex.wmconsole.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.AddUrlRequest;
import ru.yandex.wmconsole.util.FileUtil;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author aherman
 */
public class AddUrlLogService {
    private static final Logger log = LoggerFactory.getLogger(AddUrlLogService.class);

    private String addurlPathForAntispam;
    private String addurlPath;
    private String addUrlErrorPath;

    public void logUrl(AddUrlRequest addUrlRequest, String yaDomain) throws InternalException {
        addToLog(addUrlRequest, yaDomain);

        if (addUrlRequest.getFrontendIp() != null) {   // user directly adds url
            try {
                addToAntispamLog(addUrlRequest, yaDomain);
            } catch (InternalException e) {
                log.error("Failed to save url to a file for antispam (this error is not visible for users!)", e);
            }
        }
    }

    public void logUrlError(AddUrlRequest addUrlRequest) {
        String errorLine = addUrlRequest.getUrl() + " " +
                System.currentTimeMillis() + " " +
                getOrEmpty(addUrlRequest.getFrontendIp()) + " " +
                getOrEmpty(addUrlRequest.getUserId());
        try {
            FileUtil.saveToAFile(errorLine, addUrlErrorPath);
        } catch (InternalException e) {
            log.error("callAddUrl: cannot save addUrlError file (" + e + ")");
        }
    }

    private void addToLog(AddUrlRequest addUrlRequest, String yaDomain) throws InternalException {
        String logLine = addUrlRequest.getUrl() + (yaDomain == null ? "" : "\t" + yaDomain);
        FileUtil.saveToAFile(logLine, addurlPath);
        log.debug(addUrlRequest.getUrl() + " was successfully saved to a file.");
    }

    private void addToAntispamLog(AddUrlRequest addUrlRequest, String yaDomain) throws InternalException {
        String detailedLogLine = addUrlRequest.getUrl() + " " +
                System.currentTimeMillis() + " " +
                addUrlRequest.getFrontendIp() + " " +
                getOrEmpty(addUrlRequest.getUserId()) + " " +
                getOrEmpty(addUrlRequest.getUserIp()) + " " +
                getOrEmpty(addUrlRequest.getYandexUid()) + " " +
                getOrEmpty(yaDomain)
        ;
        FileUtil.saveToAFile(detailedLogLine, addurlPathForAntispam);
        log.debug(addUrlRequest.getUrl() + " was successfully saved to a file for antispam.");
    }

    private static String getOrEmpty(Long value) {
        return (value == null) ? "-" : String.valueOf(value);
    }

    private static String getOrEmpty(String value) {
        return (value == null) ? "-" : value;
    }

    @Required
    public void setAddurlPath(String addurlPath) {
        this.addurlPath = addurlPath;
    }

    @Required
    public void setAddurlPathForAntispam(String addurlPathForAntispam) {
        this.addurlPathForAntispam = addurlPathForAntispam;
    }

    @Required
    public void setAddUrlErrorPath(String addUrlErrorPath) {
        this.addUrlErrorPath = addUrlErrorPath;
    }
}
