package ru.yandex.wmconsole.service;

import ru.yandex.wmtools.common.error.InternalException;

/**
 * Gives advanced permissions for support users (support users must not verify host to get permissions
 * to watch any host information, and they can also view additional information).
 *
 * Created by IntelliJ IDEA.
 * User: baton
 * Date: 20.03.2007
 * Time: 10:09:24
 */
public class AdvancedVerifyService extends VerifyService {
    @Override
    public boolean isHostVerifiedByUser(long hostId, long userId) throws InternalException {
        return getSupportService().isSupportAndNotBlockedUser(userId);
    }
}
