package ru.yandex.wmconsole.service;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.host.dao.TblHostsMainDao;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * User: azakharov
 * Date: 24.07.14
 * Time: 15:58
 */
public class ConsistentMainMirrorService {

    private TblHostsMainDao tblHostsMainDao;
    private DispatcherHttpService dispatcherHttpService;

    public String getMainMirror(final String hostName) throws InternalException {

        final BriefHostInfo hostInfo = tblHostsMainDao.getHostIdByHostname(hostName);
        if (hostInfo == null) {
            final String mainMirror = dispatcherHttpService.getMainMirror(hostName, "webmaster-viewer");
            if (hostName.equalsIgnoreCase(mainMirror)) {
                // host is not in database and is main mirror
                return mainMirror;
            }

            final BriefHostInfo mainMirrorInfo = tblHostsMainDao.getHostIdByHostname(mainMirror);
            if (mainMirrorInfo == null) {
                // host not in database and main mirror is not in database
                return mainMirror;
            }

            if (mainMirrorInfo.getMainMirrorId() != null) {
                // main mirror from mirrors.trie is not main mirror in database

                return hostName;
            } else {
                return mainMirror;
            }
        }

        if (hostInfo.getMainMirrorId() != null) {
            // host is in database and there is main mirror for host in database
            final BriefHostInfo mainMirrorInfo = tblHostsMainDao.getBriefHostInfoByHostId(hostInfo.getMainMirrorId());
            return mainMirrorInfo.getName();
        } else {
            // host is in database and there is no main mirror for host in database
            return hostInfo.getName();
        }
    }

    public BriefHostInfo getMainMirrorBriefHostInfo(final String hostName) throws InternalException {
        final BriefHostInfo hostInfo = tblHostsMainDao.getHostIdByHostname(hostName);
        if (hostInfo == null) {
            final String mainMirror = dispatcherHttpService.getMainMirror(hostName, "webmaster-viewer");
            if (hostName.equalsIgnoreCase(mainMirror)) {
                return null;
            }

            final BriefHostInfo mainMirrorInfo = tblHostsMainDao.getHostIdByHostname(mainMirror);
            if (mainMirrorInfo.getMainMirrorId() != null) {
                // main mirror from mirrors.trie is not main mirror in database

                return null;
            } else {
                return mainMirrorInfo;
            }
        } else {
            if (hostInfo.getMainMirrorId() == null) {
                return hostInfo;
            }
            final BriefHostInfo mainMirrorInfo = tblHostsMainDao.getBriefHostInfoByHostId(hostInfo.getMainMirrorId());
            return mainMirrorInfo;
        }
    }

    @Required
    public void setTblHostsMainDao(TblHostsMainDao tblHostsMainDao) {
        this.tblHostsMainDao = tblHostsMainDao;
    }

    @Required
    public void setDispatcherHttpService(DispatcherHttpService dispatcherHttpService) {
        this.dispatcherHttpService = dispatcherHttpService;
    }
}
