package ru.yandex.wmconsole.service;

import java.util.Collections;
import java.util.Map;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmconsole.data.info.DraftMessageInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author avhaliullin
 */
public class GlobalDraftMessagesService extends AbstractDraftMessagesService<DraftMessageInfo> {
    @Override
    protected NotificationTypeEnum getNotificationType() {
        return NotificationTypeEnum.GLOBAL_MESSAGE;
    }

    @Override
    protected WMCHistoryObjectTypeEnum getWmcHistoryObjectType() {
        return WMCHistoryObjectTypeEnum.GLOBAL_MESSAGE;
    }

    @Override
    protected ParameterizedRowMapper<DraftMessageInfo> getMapper() {
        return draftMessageInfoMapper;
    }

    @Override
    protected String getAdditionalFieldsString() {
        return "";
    }

    @Override
    protected Map<String, Object> getNotifierRequestParams(DraftMessageInfo message) throws InternalException {
        return Collections.emptyMap();
    }

    @Override
    public long addNewMessage(final long authorId) throws UserException, InternalException {
        return super.addNewMessage(authorId);
    }
}
