package ru.yandex.wmconsole.service;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.wmconsole.data.SeverityEnum;
import ru.yandex.wmconsole.data.UserErrorOptions;
import ru.yandex.wmconsole.data.info.UrlErrorsWithCodeInfo;

class GroupedUrlErrorMapper implements ParameterizedRowMapper<UrlErrorsWithCodeInfo> {
    private static final String FIELD_ERROR_CODE = "error_code";
    private static final String FIELD_ERROR_COUNT = "error_count";

    private final UserErrorOptions userErrorOptions;

    public GroupedUrlErrorMapper(UserErrorOptions userErrorOptions) {
        this.userErrorOptions = userErrorOptions;
    }

    @Override
    public UrlErrorsWithCodeInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
        int code = rs.getInt(FIELD_ERROR_CODE);
        int count = rs.getInt(FIELD_ERROR_COUNT);
        SeverityEnum severity = userErrorOptions.getSeverityByCode(code);
        return new UrlErrorsWithCodeInfo(code, count, severity, null);
    }
}

