package ru.yandex.wmconsole.service;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import wmc.stubs.Stubs;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.service.AbstractExternalHttpService;

/**
 * User: azakharov
 * Date: 21.09.12
 * Time: 16:55
 */
public class HostMonHttpService extends AbstractExternalHttpService {
    private static final Logger log = LoggerFactory.getLogger(HostMonHttpService.class);
    private Boolean supportMode;
    /**
     * Загрузить в hostmon данные по хосту в хостовую БД
     *
     * @param hostname  имя хоста
     */
    public void hostMonUploadHostData(final String hostname) throws InternalException {
        log.debug("hostMonUploadHostData called");
        if (supportMode) {
            log.debug("hostMonUploadHostData in support mode is cancelled");
            throw new InternalException(
                    InternalProblem.PROCESSING_ERROR, "hostMonUploadHostData in support mode is not allowed");
        }

        Stubs.long_err_msg.Builder ans;
        try {
            ans = Stubs.long_err_msg.newBuilder().mergeFrom(httpPostResponse("uploadhostdata", createParams()
                    .addParam("hostname", hostname), 1000 * 60 * 60 * 12));
            if (ans.hasErr()) {
                if (Stubs.error_code.HostInProcess.equals(ans.getErr().getVal())) {
                    log.warn("Caught HostInProgress error");
                    return;
                }
                log.error("Can't uploadhostdata from hostmon for " + hostname);
            } else {
                log.debug("Hostmonloader data for " + hostname + " has been uploaded");
            }

            if (!ans.hasVal()) {
                log.error("Hostmonloader uploadhostdata has returned no value");
            }
            log.debug("Hostmonloader upload host data: the answer is \"" + ans.getVal().getVal() + "\"");
        } catch (IOException e) {
            log.error("Hostmonloader is unavailable");
        }
    }

    @Required
    public void setSupportMode(Boolean supportMode) {
        this.supportMode = supportMode;
    }
}
