package ru.yandex.wmconsole.service;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.wmconsole.data.DisplayNameModerationStateEnum;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.service.dao.TblDisplayNameModerationDao;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * Changes display name of the specified host.
 *
 * @author ailyin
 * @author ivan
 */
public class HostnameService extends AbstractDbService {

    private TblDisplayNameModerationDao tblDisplayNameModerationDao;

    private static final String UPDATE_NAME_QUERY =
        "UPDATE " +
            "   tbl_hosts " +
            "SET " +
            "   name = ? " +
            "WHERE " +
            "   host_id = ? " +
            "AND " +
            "   name = ? ";


    public void changeDisplayName(BriefHostInfo briefHostInfo, String displayName,
                Long userId, DisplayNameModerationStateEnum status) throws InternalException {
        tblDisplayNameModerationDao.insertChangeDisplayNameRequest(briefHostInfo, displayName, userId, status);
    }

    public void changeName(BriefHostInfo briefHostInfo, String name) throws InternalException {
        getJdbcTemplate(WMCPartition.nullPartition()).update(
                UPDATE_NAME_QUERY, name, briefHostInfo.getId(), name);
    }

    @Required
    public void setTblDisplayNameModerationDao(TblDisplayNameModerationDao tblDisplayNameModerationDao) {
        this.tblDisplayNameModerationDao = tblDisplayNameModerationDao;
    }
}
