package ru.yandex.wmconsole.service;

import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.data.info.DateCountInfo;
import ru.yandex.wmtools.common.service.IUserInfoService;
import ru.yandex.wmtools.common.util.TimeFilter;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

import java.util.Date;
import java.util.List;
import java.util.NavigableMap;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.01.2009
 * Time: 10:54:03
 */
public interface IWMCUserInfoService extends IUserInfoService {
    Pair<Boolean,Boolean> getUserOptions(long userId) throws InternalException, UserException;

    List<DateCountInfo> getNewUsersCount(final TimeFilter timeFilter) throws InternalException;

    List<DateCountInfo> getTrueUsersCount(Date fromDate, Date toDate, int numOfDays, int numOfVisits) throws InternalException;

    List<DateCountInfo> getTrueUsersCount2(final TimeFilter timeFilter) throws InternalException;

    List<DateCountInfo> getUsersWithHostsCount(final TimeFilter timeFilter) throws InternalException;

    List<DateCountInfo> getUsersWithVerifiedHostsCount(final TimeFilter timeFilter) throws InternalException;

    NavigableMap<Date, Integer> getTrueUsersInfo(final TimeFilter timeFilter) throws InternalException;

    NavigableMap<Date, Integer> getNewUsersInfo(final TimeFilter timeFilter) throws InternalException;

    NavigableMap<Date, Integer> getUsersWithVerifiedHostsInfo(final TimeFilter timeFilter) throws InternalException;

    NavigableMap<Date, Integer> getUsersWithHostsInfo(final TimeFilter timeFilter) throws InternalException;

    void updateOfflineLinksOption(long userId, boolean offlineLinksEnabled) throws InternalException;

    void updateFeedbackConfirmationOption(long userId, boolean needFeedbackConfirmation) throws InternalException;
}
