package ru.yandex.wmconsole.service;

import ru.yandex.wmtools.common.data.xmlsearch.IndexCountRequest;
import ru.yandex.wmtools.common.data.xmlsearch.InternalLinksCountRequest;
import ru.yandex.wmtools.common.data.xmlsearch.LinksCountRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: baton
 * Date: 22.11.2007
 * Time: 22:33:55
 */
public enum LinkType {
    INTERNAL_LINKS("linkint", "linkint", "internal_links_count", "internal_links_time") {
        @Override
        public XmlSearchRequest getXmlSearchRequest(String hostName) throws UserException {
            return new InternalLinksCountRequest(hostName);
        }
    },
    LINKS("link", "link", "links_count", "links_time") {
        @Override
        public XmlSearchRequest getXmlSearchRequest(String hostName) throws UserException {
            return new LinksCountRequest(hostName);
        }
    },
    INDEX_URLS("index_urls", "url", "index_count", "index_count_time") {
        @Override
        public XmlSearchRequest getXmlSearchRequest(String hostName) throws UserException {
            return new IndexCountRequest(hostName);
        }
    },;

    private final String name;
    private final String xmlSearchCommandName;
    private final String dbFieldName;
    private final String timeDbFieldName;

    LinkType(String name, String xmlSearchCommandName, String dbFieldName, String timeDbFieldName) {
        this.name = name;
        this.xmlSearchCommandName = xmlSearchCommandName;
        this.dbFieldName = dbFieldName;
        this.timeDbFieldName = timeDbFieldName;
    }

    public String getName() {
        return name;
    }

    public String getDbFieldName() {
        return dbFieldName;
    }

    public String getXmlSearchCommandName() {
        return xmlSearchCommandName;
    }

    public String getTimeDbFieldName() {
        return timeDbFieldName;
    }

    public abstract XmlSearchRequest getXmlSearchRequest(String hostName) throws UserException;
}
