package ru.yandex.wmconsole.service;

import org.apache.http.client.methods.CloseableHttpResponse;
import ru.yandex.wmtools.common.data.yt.YTAccept;
import ru.yandex.wmtools.common.data.yt.YTCommandEnum;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.service.YTService;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class OldWmYTService extends YTService {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public void readTSKV(String path, TSKVConsumer consumer) throws InternalException {
        try (CloseableHttpResponse response = request(YTCommandEnum.READ, Collections.<String, Object>singletonMap("path", path), AcceptEnum.TSKV)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), CHARSET));
            String line;
            Map<String, String> row = new HashMap<>();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("\t");
                for (String field : parts) {
                    int spaceIndex = field.indexOf('=');
                    String key = field.substring(0, spaceIndex);
                    String value = field.substring(spaceIndex + 1);
                    row.put(key, value);
                }
                if (!row.isEmpty()) {
                    consumer.consume(row);
                    row.clear();
                }
            }
        } catch (IOException e) {
            throw new InternalException(InternalProblem.SERVANT_FAILED, "YT error", e);
        }
    }

    public interface TSKVConsumer {
        void consume(Map<String, String> row) throws InternalException;
    }

    public enum AcceptEnum implements YTAccept {
        TSKV("text/tab-separated-values");
        private final String acceptHeader;

        AcceptEnum(String acceptHeader) {
            this.acceptHeader = acceptHeader;
        }

        @Override
        public String getAcceptHeader() {
            return acceptHeader;
        }
    }
}
