package ru.yandex.wmconsole.service;

import com.Ostermiller.util.CircularCharBuffer;
import org.jdom.*;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.data.xmlsearch.RegionSearchRequest;
import ru.yandex.wmtools.common.data.xmlsearch.XmlSearchRequest;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.service.IndexInfoService;
import ru.yandex.wmtools.common.service.JDomXmlSearchResultParser;
import ru.yandex.wmtools.common.service.XSLTXmlSearchResultParser;

import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 30.11.2007
 * Time: 20:03:49
 */

public class RegionsCompareService extends AbstractDbService {
    private static final Logger log = LoggerFactory.getLogger(RegionsCompareService.class);

    private static final String DOCS_COUNT_XPATH = "/docs/@count";
    private static final String QUERY_FILTER_REGEXP = "((host|url|upath|link|linkit|hostip|inurl)\\s*=\\s*|::|~|\\$\\$|<<|&&|:<|:>|:=)";
    private static final String XSL_FILTER_NAME = "/xsl/compare_regions.xsl";

    protected IndexInfoService indexInfoService;

    protected String getXslFileName() {
        return XSL_FILTER_NAME;
    }

    private String filterQuery(String query) {
        int queryLength = query.length();
        while (true) {
            query = query.replaceAll(QUERY_FILTER_REGEXP, "");
            if (queryLength == query.length()) {
                break;
            }
            queryLength = query.length();
        }
        return query;
    }

    public Document processResponse(Document response) throws InternalException {
        try {
            CircularCharBuffer occb = new CircularCharBuffer(CircularCharBuffer.INFINITE_SIZE);
            XMLOutputter outputer = new XMLOutputter();
            outputer.output(response, occb.getWriter());
            occb.getWriter().close();
            final String xslFileName = getXslFileName();
            XSLTXmlSearchResultParser parser = new XSLTXmlSearchResultParser(xslFileName);
            return new JDomXmlSearchResultParser().parseResult(parser.parseResult(occb.getReader()));
        } catch (IOException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR, "Cannot convert result in AbstractXmlSearchServantlet!", e);
        }
    }

    public Pair<String, Document> getResultForRegion(String query, long region, Pager pager) throws UserException, InternalException {
        String filteredQuery = filterQuery(query);
        XmlSearchRequest request = createRequest(filteredQuery, region, pager);
        return new Pair<String, Document>(filteredQuery, processResponse(indexInfoService.callXMLSearch(request)));
    }

    protected XmlSearchRequest createRequest(final String query, final long region, final Pager pager) {
        return new RegionSearchRequest(query, region, pager.getPageNum(), pager.getPageSize());
    }

    public int extractPagerInfo(Document response) throws InternalException {
        try {
            Object o = XPath.selectSingleNode(response, DOCS_COUNT_XPATH);
            if (o == null) {
                return 0;
            }
            if (o instanceof Attribute) {
                Attribute a = (Attribute) o;
                try {
                    return a.getIntValue();
                } catch (DataConversionException e) {
                    return 0;
                }
            }
            return Integer.parseInt(((Element) o).getText());
        } catch (NumberFormatException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR, "NumberFormatException in extractPagerInfo!", e);
        } catch (JDOMException e) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR, "JDOMException in extractPagerInfo!", e);
        }
    }

    @Required
    public void setIndexInfoService(IndexInfoService indexInfoService) {
        this.indexInfoService = indexInfoService;
    }
}
