package ru.yandex.wmconsole.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.host.dao.TblUsersHostsDao;
import ru.yandex.webmaster3.SafeNewWebmasterHttpService;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.service.error.WMCUserProblem;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Rewrite me
 * Hostfix for WMCON-5051
 * @author aherman
 */
public class SupportUsersHostsService {
    private static final Logger log = LoggerFactory.getLogger(SupportUsersHostsService.class);

    private UsersHostsService usersHostsService;
    private TblUsersHostsDao tblUsersHostsDao;
    private SafeNewWebmasterHttpService safeNewWebmasterHttpService;

    public UsersHostsInfo addHostToUser(BriefHostInfo briefHostInfo, long toUserId, long byUserId) throws InternalException {
        UsersHostsInfo usersHostsInfo = usersHostsService.getUsersHostsInfo(toUserId, briefHostInfo.getId());
        if (usersHostsInfo != null) {
            return usersHostsInfo;
        }

        log.info("Moderator {} added host {} to user {}", byUserId, briefHostInfo.getId(), toUserId);
        tblUsersHostsDao.addHostToUser(toUserId, briefHostInfo);
        return usersHostsService.getUsersHostsInfo(toUserId, briefHostInfo.getId());
    }

    public UsersHostsInfo verifyHostForUser(BriefHostInfo briefHostInfo, long forUserId, long byUserId,
            VerificationTypeEnum verificationType) throws InternalException, UserException
    {
        // check that host is added to list
        UsersHostsInfo usersHostsInfo = usersHostsService.getUsersHostsInfo(forUserId, briefHostInfo.getId());
        if (usersHostsInfo == null) {
            throw new UserException(WMCUserProblem.HOST_NOT_OWNED_BY_USER,
                    "Host " + briefHostInfo.getId() + " is not owned by user");
        }

        tblUsersHostsDao.updateVerification(briefHostInfo, forUserId, verificationType,
                "Support user " + byUserId + " changed verification to " + verificationType);

        try {
            safeNewWebmasterHttpService.verifyHost(forUserId, briefHostInfo);
        } catch (InternalException e) {
            log.error("Unable to verify webmaster3 host " + briefHostInfo.getName() + " for " + forUserId);
        }

        return usersHostsInfo;
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }

    @Required
    public void setTblUsersHostsDao(TblUsersHostsDao tblUsersHostsDao) {
        this.tblUsersHostsDao = tblUsersHostsDao;
    }

    @Required
    public void setSafeNewWebmasterHttpService(SafeNewWebmasterHttpService safeNewWebmasterHttpService) {
        this.safeNewWebmasterHttpService = safeNewWebmasterHttpService;
    }
}
