package ru.yandex.wmconsole.service;

import java.util.Date;
import java.util.List;

import ru.yandex.common.util.db.IntegerRowMapper;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.CustomRegionService;
import ru.yandex.wmtools.common.util.SqlUtil;

/**
 * @author baton
 */
public class WMCCustomRegionService extends CustomRegionService<HostDbHostInfo> {
    private static final String FIELD_REGION_ID = "region_id";

    private static final String SELECT_ALL_KEY_REGIONS_FOR_HOST_QUERY =
            "SELECT " +
                    "   DISTINCT region_id " +
                    "FROM " +
                    "   tbl_customquery_history " +
                    "WHERE " +
                    "   host_id = ? ";

    private static final String SELECT_CUSTOM_REGIONS_LIST_QUERY =
            "SELECT " +
                    "    cr.region_id AS " + FIELD_REGION_ID + " " +
                    "FROM " +
                    "    tbl_custom_regions cr " +
                    "WHERE " +
                    "    cr.host_id = ? " +
                    "ORDER BY " + FIELD_REGION_ID;

    private static final String SELECT_KEY_REGIONS_FOR_DATE_QUERY =
            "SELECT" +
                    "    DISTINCT(region_id) " +
                    "FROM " +
                    "    tbl_customquery_history " +
                    "WHERE " +
                    "    host_id = ? " +
                    "AND " +
                    "    day = ? ";


    private static final String INSERT_CUSTOM_REGION_QUERY =
            "INSERT IGNORE INTO " +
                    "    tbl_custom_regions (host_id, region_id) " +
                    "VALUES (?, ?) ";

    private static final String DELETE_CUSTOM_REGIONS_QUERY =
            "DELETE FROM " +
                    "    tbl_custom_regions " +
                    "WHERE " +
                    "    host_id = ? " +
                    "AND " +
                    "    region_id IN (%1$s) ";

    private static final String INSERT_CUSTOM_REGIONS_QUERY =
            "INSERT IGNORE INTO " +
                    "       tbl_custom_regions (host_id, region_id) " +
                    "   VALUES %1$s ";

    @Override
    protected int internalAddKeyRegionForHostQuery(HostDbHostInfo hostDbHostInfo, int regionId) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(
                INSERT_CUSTOM_REGION_QUERY, hostDbHostInfo.getHostDbHostId(), regionId);
    }

    @Override
    protected int internalRemoveCustomRegionsForHost(HostDbHostInfo hostDbHostInfo, List<Integer> regionIds) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(
                String.format(DELETE_CUSTOM_REGIONS_QUERY, SqlUtil.getCommaSeparatedList(regionIds)),
                hostDbHostInfo.getHostDbHostId());
    }

    @Override
    protected List<Integer> getKeyRegionIdsForHost(HostDbHostInfo hostDbHostInfo) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                SELECT_CUSTOM_REGIONS_LIST_QUERY, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId());
    }

    @Override
    protected List<Integer> getKeyRegionIdsForHostAndDate(HostDbHostInfo hostDbHostInfo, Date date) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                SELECT_KEY_REGIONS_FOR_DATE_QUERY, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId(), date);
    }

    @Override
    protected List<Integer> getKeyRegionIdsForHostAndAllTheTime(HostDbHostInfo hostDbHostInfo) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                SELECT_ALL_KEY_REGIONS_FOR_HOST_QUERY, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId());
    }

    @Override
    public int internalAddKeyRegionsForHostQuery(final HostDbHostInfo hostInfo, List<Integer> regionIds) throws InternalException {
        String query = String.format(INSERT_CUSTOM_REGIONS_QUERY, SqlUtil.getCommaSeparatedList(regionIds, new SqlUtil.ListParameterizer<Integer>() {
            @Override
            public String getParameter(int i, Integer obj) {
                return String.valueOf(i == 0 ? hostInfo.getHostDbHostId() : obj);
            }

            @Override
            public int getParamNumber() {
                return 2;
            }
        }));
        return getJdbcTemplate(new WMCPartition(hostInfo, null)).update(query);
    }
}
