package ru.yandex.wmconsole.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.RegionsTreeCacheService;

/**
 * @author baton
 */
public class WMCRegionsTreeCacheService extends RegionsTreeCacheService {
    private static final String FIELD_REGION_ID = "region_id";
    private static final String FIELD_REGION_TYPE = "region_type";
    private static final String FIELD_REGION_GEOTYPE = "region_geotype";
    private static final String FIELD_REGION_HIDE = "region_hide";
    private static final String FIELD_REGION_PARENT = "region_parent";

    private static final String SELECT_ALL_REGIONS_QUERY =
            "SELECT " +
                    "    r.region_id as " + FIELD_REGION_ID + ", " +
                    "    r.type as " + FIELD_REGION_TYPE + ", " +
                    "    r.geotype as " + FIELD_REGION_GEOTYPE + ", " +
                    "    r.hide as " + FIELD_REGION_HIDE + ", " +
                    "    r.parent_id as " + FIELD_REGION_PARENT + " " +
                    "FROM " +
                    "    tbl_dic_region r ";

    private static final ParameterizedRowMapper<RegionInfo> regionInfoRowMapper = new ParameterizedRowMapper<RegionInfo>() {
        @Override
        public RegionInfo mapRow(ResultSet rs, int i) throws SQLException {
            int regionId = rs.getInt(FIELD_REGION_ID);
            byte regionType = rs.getByte(FIELD_REGION_TYPE);
            byte regionGeotype = rs.getByte(FIELD_REGION_GEOTYPE);
            byte regionHide = rs.getByte(FIELD_REGION_HIDE);
            int parentId = rs.getInt(FIELD_REGION_PARENT);

            return new RegionInfo(regionId, regionType, regionHide, parentId, regionGeotype);
        }
    };

    @Override
    protected List<RegionInfo> getAllRegionsFromDb() throws InternalException {
        return getJdbcTemplate(WMCPartition.randomHostDatabase(getDatabaseCount())).query(
                SELECT_ALL_REGIONS_QUERY, regionInfoRowMapper);
    }
}
