package ru.yandex.wmconsole.service;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.service.dao.TblBlockedUsersDao;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;
import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.IHistoryObjectType;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.service.SupportService;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.03.2007
 * Time: 10:09:24
 */
public class WMCSupportService extends SupportService implements IWMCSupportService {
    private static final String SELECT_USER_IN_SUPPORT_QUERY =
            "SELECT " +
                    "    count(*) " +
                    "FROM " +
                    "    tbl_support_users " +
                    "WHERE " +
                    "    user_id = ?";

    private static final String SELECT_USER_IN_USERS_LIST_QUERY =
            "SELECT " +
                    "    count(*) " +
                    "FROM " +
                    "    tbl_users " +
                    "WHERE " +
                    "    user_id = ?";

    private static final String SELECT_USER_HAS_PERMISSIONS_QUERY =
            "SELECT " +
                    "    count(*) " +
                    "FROM " +
                    "    tbl_support_permissions " +
                    "WHERE " +
                    "    user_id = ? " +
                    "AND " +
                    "    object = ? " +
                    "AND " +
                    "    action = ? ";

    private UsersHostsService usersHostsService;

    private TblBlockedUsersDao tblBlockedUsersDao;
    private SupportUsersHostsService supportUsersHostsService;

    @Override
    public boolean isUserHasPermissionsOnAction(long userId, IHistoryObjectType type, IHistoryAction action) throws InternalException {
        long count = getJdbcTemplate(WMCPartition.nullPartition()).queryForLong(SELECT_USER_HAS_PERMISSIONS_QUERY, userId, type.getValue(), action.getValue());
        return (count == 1);
    }

    @Override
    public void cheatVerify(long userId, BriefHostInfo hostInfo) throws InternalException, UserException {
        // check permissions
        if (!isSupportAndNotBlockedUser(userId)) {
            throw new UserException(UserProblem.USER_NOT_PERMITTED, "User " + userId + " is not in list of supports or blocked!");
        }

        UsersHostsInfo usersHostsInfo = supportUsersHostsService.addHostToUser(hostInfo, userId, userId);
        if (!usersHostsInfo.getVerificationState().isVerified()) {
            supportUsersHostsService.verifyHostForUser(hostInfo, userId, userId, VerificationTypeEnum.CHEAT);
        }
    }

    @Override
    public UsersHostsInfo manualVerify(long toUserId, long actorUserId, BriefHostInfo hostInfo) throws UserException, InternalException {
        // check permissions
        if (!isSupportAndNotBlockedUser(actorUserId)) {
            throw new UserException(UserProblem.USER_NOT_PERMITTED, "User " + actorUserId + " is not in list of supports or blocked!");
        }

        return supportUsersHostsService.verifyHostForUser(hostInfo, toUserId, actorUserId, VerificationTypeEnum.MANUAL);
    }

    @Override
    public boolean isSupportUser(long userId) throws InternalException {
        long count = getJdbcTemplate(new WMCPartition(null, userId)).queryForLong(SELECT_USER_IN_SUPPORT_QUERY, userId);
        return (count == 1);
    }

    @Override
    public boolean isBlockedUser(long userId) throws InternalException {
        return tblBlockedUsersDao.isUserBlocked(userId);
    }

    @Override
    public boolean isKnownUser(long userId) throws InternalException {
        long count = getJdbcTemplate(WMCPartition.nullPartition()).queryForLong(SELECT_USER_IN_USERS_LIST_QUERY, userId);
        return (count == 1);
    }

    @Override
    public boolean isUserHaventAcceptedLicence(long userId) throws InternalException {
        return false;
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }

    @Required
    public void setTblBlockedUsersDao(TblBlockedUsersDao tblBlockedUsersDao) {
        this.tblBlockedUsersDao = tblBlockedUsersDao;
    }

    @Required
    public void setSupportUsersHostsService(SupportUsersHostsService supportUsersHostsService) {
        this.supportUsersHostsService = supportUsersHostsService;
    }
}
