package ru.yandex.wmconsole.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.common.util.db.LongRowMapper;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.data.info.SupportUserInfo;
import ru.yandex.wmtools.common.data.partition.IPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.BlackboxUserService;
import ru.yandex.wmtools.common.service.SupportUsersService;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.03.2007
 * Time: 10:09:24
 */
public class WMCSupportUsersService extends SupportUsersService {
    private static final boolean IS_SUPPORT_USER_MUST_BE_IN_USERS_LIST = true;

    private static final String FIELD_SUPPORT_USER_ID = "support_user_id";

    private static final String SELECT_SUPPORT_USERS_LIST_QUERY =
            "SELECT " +
                    "    user_id AS " + FIELD_SUPPORT_USER_ID + " " +
                    "FROM " +
                    "    tbl_support_users " +
                    "ORDER BY " + FIELD_SUPPORT_USER_ID + " " +
                    " %1$s ";

    private static final String SELECT_SUPPORT_USERS_LIST_COUNT_QUERY =
            "SELECT " +
                    "    count(*) " +
                    "FROM " +
                    "    tbl_support_users ";

    private static final String INSERT_SUPPORT_USER_QUERY =
            "INSERT INTO " +
                    "    tbl_support_users (user_id) " +
                    "VALUES (?)";

    private static final String DELETE_SUPPORT_USERS_QUERY =
            "DELETE FROM " +
                    "    tbl_support_users " +
                    "WHERE " +
                    "    user_id IN (%1$s)";

    private final ParameterizedRowMapper<SupportUserInfo> supportUserInfoMapper = new ParameterizedRowMapper<SupportUserInfo>() {
        @Override
        public SupportUserInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            long userId = rs.getLong(FIELD_SUPPORT_USER_ID);
            UserInfo userInfo = getUserService().getUserInfo(userId);
            if (userInfo == null) {
                userInfo = BlackboxUserService.createUserInfoStub(userId, "user_missed", "Not Found In Passport");
            }
            return new SupportUserInfo(userId, userInfo);
        }
    };

    @Override
    protected int removeSupportUsersQuery(final String inParamsStr, Object[] queryParams) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).update(String.format(DELETE_SUPPORT_USERS_QUERY, inParamsStr), queryParams);
    }

    /**
     * Pager is not supported.
     *
     * @param pager MUST be <code>null</code>.
     * @return Returns list of support users.
     * @throws InternalException Thrown if smth goes wrong.
     */
    @Override
    public List<SupportUserInfo> getSupportsList(Pager pager) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).pageableSelect(
                SELECT_SUPPORT_USERS_LIST_COUNT_QUERY, SELECT_SUPPORT_USERS_LIST_QUERY,
                supportUserInfoMapper, pager);
    }

    @Override
    protected List<Long> getSupportUsersList(Pager pager) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).pageableSelect(
                SELECT_SUPPORT_USERS_LIST_COUNT_QUERY, SELECT_SUPPORT_USERS_LIST_QUERY,
                new LongRowMapper(), pager);
    }

    @Override
    protected int addSupportUserQuery(long supportId) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).update(INSERT_SUPPORT_USER_QUERY, supportId);
    }

    @Override
    protected IPartition addSupportUserPartition(long supportId) {
        return WMCPartition.nullPartition();
    }

    @Override
    protected IPartition removeSupportUsersPartition(Long... supportIds) {
        return WMCPartition.nullPartition();
    }

    @Override
    protected boolean isSupportUserMustBeInUsersList() {
        return IS_SUPPORT_USER_MUST_BE_IN_USERS_LIST;
    }
}
