package ru.yandex.wmconsole.service;

import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.WMCTopInfoItem;
import ru.yandex.wmtools.common.service.TopInfoComparator;

/**
 * @author baton
 */
public class WMCTopInfoComparator extends TopInfoComparator<WMCTopInfoItem> {
    public WMCTopInfoComparator(OrderByClause orderBy) {
        super(orderBy);
    }

    @Override
    public int compare(WMCTopInfoItem o1, WMCTopInfoItem o2) {
        int res = 0;

        if (getQueryFieldName().equals(orderBy.getColumnName())) {
            res = o1.getQuery().compareTo(o2.getQuery());
        } else if (getPositionFieldName().equals(orderBy.getColumnName())) {
            if (o1.getPosition() == null) {
                if (o2.getPosition() == null) {
                    return 0;
                } else {
                    return 1;
                }
            }
            if (o2.getPosition() == null) {
                return -1;
            }

            if (o1.getPosition() > o2.getPosition()) {
                res = 1;
            } else if (o1.getPosition() < o2.getPosition()) {
                res = -1;
            }
        } else if (getClicksFieldName().equals(orderBy.getColumnName())) {
            if (o1.getClicks() > o2.getClicks()) {
                res = 1;
            } else if (o1.getClicks() < o2.getClicks()) {
                res = -1;
            } else {
                if (o1.getClicksTopRank() == null) {
                    if (o2.getClicksTopRank() == null) {
                        return 0;
                    } else {
                        return -1;
                    }
                } else if (o2.getClicksTopRank() == null) {
                    return 1;
                }

                if (o1.getClicksTopRank() > o2.getClicksTopRank()) {
                    res = -1;
                } else if (o1.getClicksTopRank() < o2.getClicksTopRank()) {
                    res = 1;
                }
            }
        } else if (getShowsFieldName().equals(orderBy.getColumnName())) {
            if (o1.getShows() > o2.getShows()) {
                res = 1;
            } else if (o1.getShows() < o2.getShows()) {
                res = -1;
            } else {
                if (o1.getShowsTopRank() == null) {
                    if (o2.getShowsTopRank() == null) {
                        return 0;
                    } else {
                        return -1;
                    }
                } else if (o2.getShowsTopRank() == null) {
                    return 1;
                }

                if (o1.getShowsTopRank() > o2.getShowsTopRank()) {
                    res = -1;
                } else if (o1.getShowsTopRank() < o2.getShowsTopRank()) {
                    res = 1;
                }
            }
        } else {
            throw new AssertionError("Unknown type of sorting");
        }

        if (!orderBy.isAscending()) {
            res = -res;
        }

        return res;
    }

    @Override
    protected String getShowsFieldName() {
        return WMCTopInfoService.FIELD_SHOWS;
    }

    @Override
    protected String getClicksFieldName() {
        return WMCTopInfoService.FIELD_CLICKS;
    }

    protected String getPositionFieldName() {
        return WMCTopInfoService.FIELD_POSITION;
    }

    @Override
    protected String getQueryFieldName() {
        return WMCTopInfoService.FIELD_QUERY;
    }
}
