package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.db.StringRowMapper;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.all.about.url.UrlRequestId;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.List;
import java.util.Map;

/**
 * User: azakharov
 * Date: 04.12.13
 * Time: 13:13
 */
public class TblAllAboutUrlCanonicalDao extends AbstractDbService {

    /**
     * Получить список канонических URL для заданного отчёта
     *
     * @param hostDbHostInfo        информация из хостовой базы данных
     * @param requestId             идентификатор отчёта
     * @return                      список канонических URL для заданного URL
     * @throws InternalException    ошибка при обращении к базе данных
     */
    public List<String> getRelCanonicalTargetUrls(final HostDbHostInfo hostDbHostInfo, final UrlRequestId requestId) throws InternalException {
        final String query = "SELECT url FROM tbl_all_about_url_canonical WHERE num = ?";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(query, new StringRowMapper(), requestId.getId());
    }

    public Map<String, Object> dumpAllAboutUrlCanonicalInfo(final HostDbHostInfo hostDbHostInfo, final UrlRequestId requestId) throws InternalException {
        final String q = "SELECT num, url FROM tbl_all_about_url_canonical WHERE num = ?";
        List<Map<String, Object>> rs = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(q, mapper, requestId.getId());
        return Cu.emptyIfNull(Cu.firstOrNull(rs));
    }

    private static final ParameterizedRowMapper<Map<String,Object>> mapper = new MapMapper();
    public static class MapMapper extends ColumnMapRowMapper implements ParameterizedRowMapper<Map<String, Object>> {
    }
}
