package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.all.about.url.UrlRequestId;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.List;
import java.util.Map;

/**
 * User: azakharov
 * Date: 24.02.14
 * Time: 17:07
 */
public class TblAllAboutUrlHtarcDao extends AbstractDbService {

    public Map<String, Object> dumpAllAboutUrlHtarcInfo(final HostDbHostInfo hostDbHostInfo, final UrlRequestId id) throws InternalException {
        final String q = "SELECT num, http_code, last_access, status FROM tbl_all_about_url_htarc WHERE num = ? ";
        List<Map<String, Object>> rs = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(q, mapper, id.getId());
        return Cu.emptyIfNull(Cu.firstOrNull(rs));
    }

    private static final ParameterizedRowMapper<Map<String,Object>> mapper = new MapMapper();
    public static class MapMapper extends ColumnMapRowMapper implements ParameterizedRowMapper<Map<String, Object>> {
    }
}
